﻿using System.ComponentModel.DataAnnotations;

namespace FluentValidation.Models
{
    public class CoffeeModel
    {
        [Required]
        public string Title { get; set; }
        
        [MaxLength(25)]
        public string? Description { get; set; }
        
        [Required]
        [StringLength(8, MinimumLength = 8, ErrorMessage = "The Bar Code must be a mandatory string length of 8.")]
        public string? BarCode { get; set; }
    }
}
